package gov.va.genisis2.converter;

import org.springframework.stereotype.Component;

import gov.va.genisis2.common.enums.RefreshStatusEnum;
import gov.va.genisis2.model.UserRefreshHistory;
import gov.va.genisis2.util.DateUtil;

/**
 * This class is used to convert UserRefreshHistoryDTO to UserRefreshHistory
 * entity and vice-versa.
 * 
 * @author Prasad Thummalapalli
 *
 */
@Component
public class UserRefreshHistoryConverter {

	public UserRefreshHistory populateUserRefreshHistory(String username) {
		UserRefreshHistory userRefreshHistory = new UserRefreshHistory();

		userRefreshHistory.setScheduledBy(username);
		userRefreshHistory.setStartDate(DateUtil.getTodaysDate());
		userRefreshHistory.setStatus(RefreshStatusEnum.STARTED.getDesc());

		return userRefreshHistory;
	}
	
	public UserRefreshHistory populateUserRefreshHistory(UserRefreshHistory userRefreshHistory) {
		userRefreshHistory.setEndDate(DateUtil.getTodaysDate());
		userRefreshHistory.setStatus(RefreshStatusEnum.COMPLETED.getDesc());

		return userRefreshHistory;
	}
	
	public UserRefreshHistory populateUserRefreshHistory(UserRefreshHistory userRefreshHistory, String errorMessage) {
		userRefreshHistory.setStatus(RefreshStatusEnum.FAILED.getDesc());
		userRefreshHistory.setErrorMessage(errorMessage);

		return userRefreshHistory;
	}
}
